"use server"

import crypto from 'crypto';

export type Block = {
  id?: string;
  type: string;
  content: string;
};

let blocks: Block[] = [
  { id: crypto.randomUUID(), type: 'h1', content: 'A Fun Project' },
  { id: crypto.randomUUID(), type: 'h2', content: 'Chill Cat' },
  { id: crypto.randomUUID(), type: 'img', content: 'https://gratisography.com/wp-content/uploads/2024/01/gratisography-cyber-kitty-800x525.jpg' },
  { id: crypto.randomUUID(), type: 'h3', content: 'Cool Office' },
  { id: crypto.randomUUID(), type: 'img', content: 'https://flowbite.s3.amazonaws.com/blocks/marketing-ui/content/content-gallery-3.png' },
  { id: crypto.randomUUID(), type: 'p', content: 'Thank You Replo!' },
  { id: crypto.randomUUID(), type: 'img', content: 'https://cdn.prod.website-files.com/6684f670fdeb125226508165/66892d24a1df556c172b06eb_Replo%20LOGO.svg' },
  { id: crypto.randomUUID(), type: 'p', content: 'Done 🥳' },
];

export async function getBlocksAction() {
  return blocks;
}

export async function addBlockAction(block: Block) {
  blocks.push(Object.assign({
    id: crypto.randomUUID(),
  }, block));
}

export async function deleteBlockAction(id: string) {
  blocks = blocks.filter(block => block.id !== id);
}

export async function updateBlockAction({ id, content, type }: Block) {
  const block = blocks.find(block => block.id === id);
  if (!block) return;
  if (content) {
    block.content = content;
  }
  if (type) {
    block.type = type;
  }
}
