"use client"

import { useCallback } from 'react';

import { Block, updateBlockAction } from '@actions';

export default function ContextMenu({ coordinates, focusedBlock, setContextMenuCoordinates, setFetchData }: {
  coordinates: { x: number; y: number },
  focusedBlock: Block | undefined,
  setContextMenuCoordinates: React.Dispatch<React.SetStateAction<{ x: number; y: number } | undefined>> | undefined,
  setFetchData: React.Dispatch<React.SetStateAction<boolean>>,
}) {
  const handleClick = useCallback((type: string) => {
    setContextMenuCoordinates?.(undefined);
    updateBlockAction({ ...focusedBlock, type } as Block);
    setFetchData(true);
  }, [focusedBlock, setContextMenuCoordinates, setFetchData]);

  const handleMouseDown = useCallback((e: React.MouseEvent) => {
    e.preventDefault();
  }, []);

  const listClass = 'absolute bg-white border border-gray-200 font-medium rounded-lg overflow-hidden text-gray-900 text-sm w-48 z-20';
  const listItemClass = 'px-4 py-2 border-b border-gray-200 cursor-pointer hover:bg-gray-100 hover:text-teal-500';

  return (
    <div className={listClass} style={{ left: coordinates.x + 10, top: coordinates.y + 10 }}>
      <ul>
        <li className={listItemClass} onClick={() => handleClick('h1')} onMouseDown={handleMouseDown}>Heading 1</li>
        <li className={listItemClass} onClick={() => handleClick('h2')} onMouseDown={handleMouseDown}>Heading 2</li>
        <li className={listItemClass} onClick={() => handleClick('h3')} onMouseDown={handleMouseDown}>Heading 3</li>
        <li className={listItemClass} onClick={() => handleClick('p')} onMouseDown={handleMouseDown}>Text</li>
        <li className={listItemClass} onClick={() => handleClick('img')} onMouseDown={handleMouseDown}>Image</li>
      </ul>
    </div>
  );
}
