"use client"

import { useEffect, useState } from 'react';

import { Block, getBlocksAction } from '@actions';
import ContextMenu from '@components/ContextMenu';
import DocumentBlock from '@components/DocumentBlock';

export default function DocumentEditor() {
  const [blocks, setBlocks] = useState<Block[]>([]);
  const [contextMenuCoordinates, setContextMenuCoordinates] = useState<{ x: number; y: number } | undefined>();
  const [focusedBlock, setFocusedBlock] = useState<Block | undefined>();
  const [fetchData, setFetchData] = useState(true);

  useEffect(() => {
    if (!fetchData) return;

    const updateBlocks = async () => {
      const updatedBlocks = await getBlocksAction();
      setBlocks(updatedBlocks);
    };

    updateBlocks();

    setFetchData(false);
  }, [fetchData]);

  return (
    <div className="p-5">
      {blocks.map(block => <DocumentBlock key={block.id} block={block} setFetchData={setFetchData} setFocusedBlock={setFocusedBlock} setContextMenuCoordinates={setContextMenuCoordinates} />)}
      <DocumentBlock setFetchData={setFetchData} />
      {contextMenuCoordinates && <ContextMenu coordinates={contextMenuCoordinates} focusedBlock={focusedBlock} setContextMenuCoordinates={setContextMenuCoordinates} setFetchData={setFetchData} />}
    </div>
  );
}
